/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.mysql.test;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.stalactite.sql.mysql.test.MySQLDataSource;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.utility.DockerImageName;

public class MySQLEmbeddableDataSource
extends UrlAwareDataSource
implements Closeable {
    public static final int MYSQL_DEFAULT_PORT = 3306;
    public static final int DEFAULT_PORT = 3306;
    private static final Map<Integer, MySQLContainer> USED_PORTS = new HashMap<Integer, MySQLContainer>();
    private MySQLContainer container;
    private final int port;

    public MySQLEmbeddableDataSource() {
        this(3306);
    }

    public MySQLEmbeddableDataSource(int port) {
        this(port, "test" + Integer.toHexString(new Random().nextInt()));
    }

    private MySQLEmbeddableDataSource(int port, String databaseName) {
        super("jdbc:mariadb://localhost:" + port + "/" + databaseName);
        this.port = port;
        this.start(databaseName);
        this.setDelegate((DataSource)((Object)new MySQLDataSource("localhost:" + port, databaseName, this.container.getUsername(), this.container.getPassword())));
    }

    private void start(String databaseName) {
        this.container = USED_PORTS.get(this.port);
        if (this.container == null) {
            MySQLContainer mariaDBContainer = new MySQLContainer(DockerImageName.parse((String)"mysql:8.0"));
            mariaDBContainer.withUsername("root").withPassword("").setPortBindings(Arrays.asList(this.port + ":" + 3306));
            mariaDBContainer.start();
            USED_PORTS.put(this.port, mariaDBContainer);
            this.container = mariaDBContainer;
        }
        try {
            this.container.createConnection("").prepareStatement("create schema " + databaseName).execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        USED_PORTS.get(this.port).stop();
    }
}

